﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace PowerAmpDemoNS
{
    public interface IVsag
    {
        void closeVsgVsa();
        void configEdgeCgsmMeas(string standard, double frequency, double RefLevel, int numAverages, string type);
        void configEdgeEvmMeas(string standard, double frequency, double RefLevel);
        void configEdgeOrfsMeas(string standard, double frequency, double RefLevel, int numAverages, string type);
        void configEvDoRhoMeas(string standard, double frequency, double RefLevel);
        void configGsmCgsmMeas(string standard, double frequency, double RefLevel, int numAverages, string type);
        void configGsmEvmMeas(string standard, double frequency, double RefLevel);
        void configGsmOrfsMeas(string standard, double frequency, double RefLevel, int numAverages, string type);
        void configLteEvmMeas(string standard, string bw, double frequency, double RefLevel);
        void configLteTddEvmMeas(string standard, string bw, double frequency, double RefLevel);
        void configTdscdmaEvmMeas(string standard, double frequency, double RefLevel);
        void configureTriggers();
        void configVsaTrigger(string triggerType, double delay = 50e-6);
        void configWcdmaEvmMeas(string standard, double frequency, double RefLevel);
        void configWlanMeas(string standard, double frequency, double RefLevel, int evmAvgCount, int semAvgCount);
        void Delay(int mSec);
        void generatePowerRampArb(string refName, double minPower, double maxPower, double duration, double sampleRate);
        void generatePulseArbSequence(string refName, double leadTime, double dutyCycle);
        double getGausFilterWeight(double freq, double bandwidth);
        double getInputAtten(double frequency, int path);
        int getNumberSamples(string refName);
        double getOutputAtten(double frequency, int path);
        double getRrcFilterWeightSquared(double freq, double symbolRate, double alpha);
        string getXAppScpi(int length);
        void initCalData(double inputLoss = 0, double outputLoss = 0);
        void initVsagAlignments();
        void initVsgVsa();
        void iqDataTo89600File(double duration, string fileName);
        double linear(double x, double x0, double x1, double y0, double y1);
        void loadShortVsgWaveform(string filePath, string fileName, double startTime, double timeToLoad);
        void loadVsgWaveform(string filePath, string fileName);
        void loadXapps(string[] xAppsNames);
        void lockVsa();
        void measEdgeCgsm(double frequency);
        void measEdgeEvm();
        void measEdgeOrfs(int numOffsets, string orfsType);
        void measEvDoRho();
        void measFftAcpr();
        void measGainComp(double duration, double minPower);
        void measGsmAcpr(int numAverages);
        void measGsmCgsm(double frequency);
        void measGsmEvm();
        void measGsmFftAcpr(int numAverages);
        void measGsmOrfs(int numOffsets, string orfsType);
        void measLteAcpr();
        void measLteEvm();
        void measLteFftAcpr();
        void measLteNS();
        void measLteTddEvm();
        int measPoutFft();
        void measPwrHarms(bool meas2, bool meas3);
        void measPwrHarms2(bool[] harmsToMeasure);
        void measSpecHarms(bool meas2, bool meas3);
        void measSpecHarms2(bool[] harmsToMeasure);
        void measStdAcpr();
        void measStdPout();
        void measTdscdmaEvm();
        void measWcdmaEvm();
        void measWlanEvm();
        void measWlanSem(int numOffsets);
        void readCalData(string filePath, string fileName);
        void runDcOffsetCal(double[] freqs, string waveform);
        void runPowerCal(string resourceDesc, string testWaveform, double[] freqs, double calPowerLevel, string filePath, bool align = false, double nominalInLoss = 0, double nominalOutLoss = 0);
        void sendXappScpi(string command);
        int servoInputPower(double targetPout, double poutMargin);
        int servoInputPowerFft(double targetPout, double poutMargin);
        void setTestFreq(double centerFreq);
        void setTestFreqWithBaseband(double centerFreq, double offsetFreq);
        void setupParameters(string condition);
        void setupVsa(double centerFreq, double targetPout, bool logData = true);
        void setupVsgVsa(string testWaveform, double centerFreq, double targetPout, double targetGain, bool useShortWaveform = false, double shortTime = 0, bool isSequence = false);
        void setVsgIqDelay(double delay, bool apply = false);
        void setVsgIqScale(double scale, bool apply = false);
        void setXappFreq(double centerFreq);
        void setXAppMode(bool isLocalMode);
        void setXAppVisible(bool isVisible);
        
        void showVsaMonitor();
        void showVsgMonitor();
        void stopVsaMonitor();
        void stopVsgMonitor();

        void stopModulation();
        void testCaldata();
        void unlockVsa();
        double voltsSquare2dBm(double voltsSquared, double impedance);
        bool simulateHardware { set; get; }
        string VsaResource { set; get; }
        string VsgResource { set; get; }
        string M9018resource { set; get; }
        bool useM9300 { set; get; }
        bool showM90xaDisplay { set; get; }
        bool fftServo { set; get; }
        bool fftAcpr { set; get; }
        bool alignVsg { set; get; }
        bool alignVsa { set; get; }

    }

}
